//
//  TTTMapViewController.m
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 10/20/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import "TTTWhereAmIViewController.h"

@interface TTTWhereAmIViewController ()

@end

@implementation TTTWhereAmIViewController

    @synthesize thisMapView;
    @synthesize findButton;
    @synthesize locateMeButton;
    @synthesize exitButton;
    @synthesize locateMeTextField;
    @synthesize findTextField;

    CLGeocoder *myGeocoder;

    CLLocation *myLocation = nil;

    - (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
    {
        self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
        if (self) {
            // Custom initialization
        }
        return self;
    }

    - (void)viewDidLoad{
        [super viewDidLoad];
        // Do any additional setup after loading the view.
        locateMeTextField.enabled = NO; // Prevent typing in this field
        [locateMeButton setEnabled:NO]; // Disable button till location found
        
        thisMapView.showsUserLocation = YES; // show ball at location
        
        myGeocoder = [[CLGeocoder alloc] init]; // Create a geocoder
        
        // Set delegate to Map View so as to listen for location changes
        [thisMapView setDelegate:self];
    }

    -(IBAction)doneEnteringFind:(id)sender {
        UITextField *theField = (UITextField*)sender;
        [theField resignFirstResponder];
    }

    - (IBAction) find:(id)sender{
        NSString *findString = [findTextField text];
        [myGeocoder geocodeAddressString:findString completionHandler:^(NSArray* placemarks, NSError* error){
                if ([placemarks count] > 0){
                    MKPlacemark *aPlacemark = [placemarks objectAtIndex:0];
                    [thisMapView setCenterCoordinate:aPlacemark.location.coordinate animated:YES];
                }
        }];
    }

    - (IBAction) locateMe:(id)sender{
        
        // Lookup the information for the current location of the user.
        [myGeocoder reverseGeocodeLocation:myLocation completionHandler:^(NSArray *placemarks, NSError *error) {
            if ((placemarks != nil) && (placemarks.count > 0)) {
                // get a placemark - there should be only one most of the time
                MKPlacemark *placemark = [placemarks objectAtIndex:0];
                
                // Convert the location to a string
                NSString *myLocationString = [[NSArray arrayWithObjects :placemark.subThoroughfare,
                                               @" ",
                                               placemark.thoroughfare,
                                               @",",
                                               placemark.locality,
                                               @",",
                                               placemark.administrativeArea,
                                               @",",
                                               placemark.country,
                                               @" ",
                                               placemark.postalCode,
                                               nil]
                                              componentsJoinedByString:@""];
                [locateMeTextField setText:myLocationString];
                
                [thisMapView setCenterCoordinate:placemark.location.coordinate animated:YES];

            } else {
                // Handle errors.
                [locateMeTextField setText:@"Current location not found"];
            }
        }];
    
    }

    - (IBAction) exit:(id)sender {
        [self dismissViewControllerAnimated:YES completion:nil];
    }

    - (void)mapView:(MKMapView *)mapView didUpdateUserLocation:(MKUserLocation *)userLocation {
    
        if ((userLocation.coordinate.latitude != 0.0) &&
            (userLocation.coordinate.longitude != 0.0)){
            // Center the map
            [thisMapView setCenterCoordinate:userLocation.coordinate animated:YES];
            
            //Save the location from userLocation
            myLocation = [userLocation location];
            
            // Enable Locate Me button
            if (myLocation != nil)[locateMeButton setEnabled:YES];
        }

    }

    - (void)didReceiveMemoryWarning{
        [super didReceiveMemoryWarning];
        // Dispose of any resources that can be recreated.
    }

@end
